<?php
class PortalAdmin
{
  private $dbo = null;
  public $zalogowany_adm = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany_adm = $this->getActualAdmin();
  }
  
  function initDB($host, $user, $pass, $db)
  {
    $dbo = new MyDB($host, $user, $pass, $db);
    if($dbo->connect_errno){
      $msg = "Brak poczenia z baz danych: "
           . $dbo->connect_error;
      throw new Exception($msg);
    }
    return $dbo;
  }

  function getActualAdmin()
  {
    if(isset($_SESSION['zalogowany_adm'])){
      return $_SESSION['zalogowany_adm'];
    }
    else{
      return null;
    }
  }
  
  function setAdminMessage($komunikat)
  {
    $_SESSION['komunikat_adm'] = $komunikat;
  }
  
  function getAdminMessage()
  {
    if(isset($_SESSION['komunikat_adm'])){
      $komunikat = $_SESSION['komunikat_adm'];
      unset($_SESSION['komunikat_adm']);
      return $komunikat;
    }
    else {
      return null;
    }
  }
  
  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostay przekazane parametry
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie dugoci przekazanych cigw
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userNameLength = mb_strlen($user, 'UTF8');
    $userPassLength = mb_strlen($pass, 'UTF8');
    
    if($userNameLength < 3 || $userNameLength > 20 ||
       $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znakw specjalnych w parametrach
    $user = $this->dbo->real_escape_string($user);
    
    //Wykonanie zapytania sprawdzajcego poprawno danych
    $query = "SELECT Haslo, Nazwa, Id "
           . "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystpi bd: nieprawidowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wynikw zapytania
    if($result->num_rows != 1){
      //Brak uytkownika o wskazanej nazwie lub zbyt wiele wynikw
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania hase
      if($pass != $pass_db){
      //Wersja z kodowaniem hase
      //if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany_adm'] = new User($row[2], $row[1]);
      }
      
      //Obsuga przywilejw
      
      //Utworzenie zmiennej sesji, jeli konieczne
      /*if(!isset($_SESSION['przywileje'])){
        $_SESSION['przywileje'] = array();
      }*/
      
      //Zapytanie pobierajce dane
      $query = "SELECT PrzywilejId FROM Uzytkownicy_Przywileje "
             . "WHERE UserId=" . $row[2];
      
      //Zapis danych o przywilejach z zmiennej sesji
      if($result = $this->dbo->query($query)){
         while($row = $result->fetch_row()){
           $_SESSION['zalogowany_adm']->przywileje[$row[0]] = true;
         }
      }
      
      //Rezultat logowania
      if(isset($_SESSION['zalogowany_adm']->przywileje[1])){
        return LOGIN_OK;
      }
      else{
        return NO_ADMIN_RIGHTS;
      }
    }
  }
  
  function logout()
  {
    $this->zalogowany_adm = null;
    if(isset($_SESSION['zalogowany_adm'])){
      unset($_SESSION['zalogowany_adm']);
      //unset($_SESSION['przywileje']);
      /*if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();*/
    }
  }
  
  function usersAdmin()
  {
    if(!isset($this->zalogowany_adm->przywileje[2])){
      echo 'Brak uprawnie';
      return;
    }

    $ua = new UsersAdmin($this->dbo);
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    switch($wtd){
      case 'showEditForm':
        $ua->showEditForm('edit');
        break;
      case 'showAddForm':
        $ua->showEditForm('add');
        break;
      case 'showSearchForm':
        $ua->showSearchForm();
        break;
      case 'addUser' :
        $id = 0;
        switch($ua->editUser('add', $id)){
          case ACTION_OK :
            $this->setAdminMessage("Uytkownik zosta dodany (id = $id).");
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
            break;
          case INVALID_USER_NAME:
            $this->setAdminMessage('Nieprawidowa nazwa uytkownika.');
            break;
          case USER_NAME_ALREADY_EXISTS:
            $this->setAdminMessage('Uytkownik o podanej nazwie istnieje w bazie.');
            break;
          case USER_ID_ALREADY_EXISTS:
            $this->setAdminMessage('Uytkownik o podanym id istnieje w bazie.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Bd serwera. Uytkownik nie zosta dodany.');
        }
        header('Location:index.php?action=usersAdmin&wtd=showAddForm');
        break;
      case 'modifyUser' :
        $id = 0;
        switch($ua->editUser('edit', $id)){
          case ACTION_OK :
            $this->setAdminMessage('Dane zostay zmienione.');
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
            break;
          case INVALID_USER_NAME:
            $this->setAdminMessage('Nieprawidowa nazwa uytkownika.');
            break;
          case FORM_DATA_MISSING:
            $this->setAdminMessage('Brak danych z formularza.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Bd serwera. Danie nie zostay zmienione.');
        }
        header("Location:index.php?action=usersAdmin&wtd=showEditForm&id=$id");
        break;
      case 'searchUser' :
        $ua->showSearchForm();
        switch ($ua->searchUser()){
          case ACTION_OK:
            break;
          case USER_NOT_FOUND:
            echo 'Nie znaleziono uytkownika.';
            break;
          case FORM_DATA_MISSING :
            echo 'Brak danych z formularza.';
            break;
          case INVALID_USER_ID :
            echo 'Bdny identyfikator uytkownika.';
            break;
          case INVALID_USER_NAME :
            echo 'Bdna nazwa uytkownika.';
            break;
          case SERVER_ERROR:
          default:
            echo 'Bd serwera.';
        }
        break;
      case 'deleteUser':
        switch($ua->deleteUser()){
          case ACTION_OK:
            $this->setAdminMessage('Uytkownik zosta usunity.');
            break;
          case USER_NOT_FOUND:
            $this->setAdminMessage('Brak uytkownika o podanym id.');
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
            break;
          case SERVER_ERROR:
          default:
           $this->setAdminMessage('Bd serwera.');
        }
        header('Location:index.php?action=usersAdmin&wtd=showList');
        break;
      case 'showList' :
      default:
        $ua->showList(ROWS_ON_PAGE);
    }
  }
  
  function getHeaderLinks(){
    $str = '';
    if($this->zalogowany_adm){
      if(isset($this->zalogowany_adm->przywileje[2])){
        $str .= '<a href="index.php?action=usersAdmin">'
             . 'Zarzdzanie uytkownikami</a> | ';
      }
      if(isset($this->zalogowany_adm->przywileje[3])){
        $str .= '<a href="index.php?action=newsAdmin">'
             . 'Zarzdzanie newsami</a> | ';
      }
      if(isset($this->zalogowany_adm->przywileje[4])){
        $str .= '<a href="index.php?action=subscriptionsAdmin">'
             . 'Zarzdzanie subskrypcjami</a> | ';
      }
    }
    return $str;
  }
  
  function newsAdmin()
  {
    if(!isset($this->zalogowany_adm->przywileje[3])){
      echo 'Brak uprawnie';
      return;
    }

    $na = new NewsAdmin($this->dbo);
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    switch($wtd){
      case 'showEditForm':
        $na->showEditForm('edit');
        break;
      case 'showAddForm':
        $na->showEditForm('add');
        break;
      case 'showSearchForm':
        $na->showSearchForm();
        break;
      case 'addNews' :
        switch($na->editNews('add')){
          case ACTION_OK :
            $this->setAdminMessage('News zosta dodany.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator news.');
            break;
          case NEWS_ID_ALREADY_EXISTS:
            $this->setAdminMessage('News o podanym id istnieje w bazie.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnie do edycji.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Bd serwera. Uytkownik nie zosta dodany.');
        }
        header('Location:index.php?action=newsAdmin&wtd=showAddForm');
        break;
      case 'modifyNews' :
        $id = 0;
        switch($na->editNews('edit', $id)){
          case ACTION_OK :
            $this->setAdminMessage('Dane zostay zmienione.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator news.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnie do edycji.');
            break;
          case FORM_DATA_MISSING:
            $this->setAdminMessage('Brak danych z formularza.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Bd serwera. Danie nie zostay zmienione.');
        }
        header("Location:index.php?action=newsAdmin&wtd=showEditForm&id=$id");
        break;
      case 'searchNews' :
        $na->showSearchForm();
        switch ($na->searchNews()){
          case ACTION_OK:
            break;
          case NEWS_NOT_FOUND:
            echo 'Nie znaleziono newsa.';
            break;
          case FORM_DATA_MISSING :
            echo 'Brak danych z formularza.';
            break;
          case INVALID_NEWS_ID :
            echo 'Bdny identyfikator newsa.';
            break;
          case SERVER_ERROR:
          default:
            echo 'Bd serwera.';
        }
        break;
      case 'deleteNews' :
        switch($na->deleteNews()){
          case ACTION_OK:
            $this->setAdminMessage('News zosta usunity.');
            break;
          case NEWS_NOT_FOUND:
            $this->setAdminMessage('Brak newsa o podanym id.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidowy identyfikator newsa.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnie.');
            break;
          case SERVER_ERROR:
          default:
           $this->setAdminMessage('Bd serwera.');
        }
        header('Location:index.php?action=newsAdmin&wtd=showList');
        break;
      case 'showList' :
      default:
        $na->showList(ROWS_ON_PAGE);
    }
  }
  
  function subscriptionsAdmin()
  {
    //Sprawdzenie uprawnie
    if(!isset($this->zalogowany_adm->przywileje[4])){
      echo 'Brak uprawnie';
      return;
    }
    
    $sa = new SubscriptionsAdmin($this->dbo);
    
    //Sprawdzenie, czy zosta przekazany parametr wtd
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    
    //Wywoanie metod w zalenoci od wartoci zapisanej w $wtd
    switch($wtd){
      case 'getEmailsList':
        switch ($sa->getEmailsList()){
          case ACTION_OK :
            break;
          case SERVER_ERROR :
          default :
            $this->setAdminMessage('Bd serwera. Lista nie jest dostpna.');
            header('Location:index.php?action=subscriptionsAdmin&wtd=showList');
        }
        break;
      case 'showList':
      default:
        switch($sa->showList()){
          case ACTION_OK :
            break;
          case SERVER_ERROR:
          default:
           echo 'Bd serwera. Lista nie jest dostpna.';
        }
    }
  }
  
}
?>